# Briar's APT repo

This project contains helper scripts around Briar's APT repository. To
use the apt repository to install Briar's apps on your device, do the
following:
```bash
# Download Briar's PGP key
wget -O- https://briarproject.org/keys/contact.asc | sudo apt-key add -

# Add Briar's repo to APT's sources list
echo "deb [arch=amd64] https://apt.briarproject.org/ bullseye main" | sudo tee -a /etc/apt/sources.list.d/briar-bullseye.list

# Update APT and install e.g. Briar GTK
sudo apt update && sudo apt install briar-gtk
```

## How it works

The packages in this apt repo are built reproducibly by various
different reproducers:

* [briar-debian-reproducer](https://code.briarproject.org/briar/briar-debian-reproducer)
* [briar-gtk-reproducer](https://code.briarproject.org/briar/briar-gtk-reproducer)
* [python-briar-wrapper-reproducer](https://code.briarproject.org/briar/python-briar-wrapper-reproducer)

Later on these built .deb files are collected by _aptly_, a tool for
maintaining apt repositories.

## How to use

When setting up the apt repo, call `./setup.sh`.

Once you've built .deb files, place them together with the source packages
into _debs-to-add/_ and call `./add-debs.sh`. This will add those
binary and source packages to the repository, create a new snapshot and update
_aptly/public/_ which can then be published by e.g. _rsync_:
```bash
rsync -avzPh --progress --checksum --delete-after aptly/public/ briar:/var/www/apt/
```

For adding a new release of e.g. Briar GTK, you would need to place the
following files into _debs-to-add/_:
```
briar-headless_1.2.18.orig.tar.gz
briar-headless_1.2.18-1.debian.tar.xz
briar-headless_1.2.18-1.dsc
briar-headless_1.2.18-1_amd64.buildinfo
briar-headless_1.2.18-1_amd64.changes
briar-headless_1.2.18-1_amd64.deb
```

## More information

* [aptly - Debian Manpages](https://manpages.debian.org/buster/aptly/aptly.1.en.html)
