#!/bin/bash
set -x
set -e

CONFIG="aptly.conf"
GPG_ID="3D7EA4950100A0D222C970717C23232F3BF374D7"

REPO_NAME="stable"
DISTRIBUTION="bullseye"

SNAPSHOT="$REPO_NAME-$(date +"%D %T")"

# Add .deb files to repo
aptly -config="$CONFIG" repo include -accept-unsigned -repo="$REPO_NAME" debs-to-add/
# aptly -config="$CONFIG" repo add -remove-files "$REPO_NAME" debs-to-add/  # alternative to `repo include`
aptly -config="$CONFIG" repo show "$REPO_NAME"

# Create snapshot
aptly -config="$CONFIG" snapshot create "$SNAPSHOT" from repo "$REPO_NAME"
aptly -config="$CONFIG" snapshot show "$SNAPSHOT"

# Publish snapshot
aptly -config="$CONFIG" publish switch -gpg-key="$GPG_ID" "$DISTRIBUTION" "$SNAPSHOT"
aptly -config="$CONFIG" publish show "$DISTRIBUTION"
