#!/bin/bash
set -x
set -e

CONFIG="aptly.conf"
GPG_ID="3D7EA4950100A0D222C970717C23232F3BF374D7"

REPO_NAME="stable"
DISTRIBUTION="bullseye"
COMMENT="Official APT repository of The Briar Project"

SNAPSHOT="$REPO_NAME-initial-$(date +"%D %T")"

# Create repository
aptly -config="$CONFIG" repo create -comment="$COMMENT" -distribution="$DISTRIBUTION" "$REPO_NAME"

# Create first snapshot
aptly -config="$CONFIG" snapshot create "$SNAPSHOT" from repo "$REPO_NAME"
aptly -config="$CONFIG" snapshot show "$SNAPSHOT"

# Publish first snapshot
aptly -config="$CONFIG" publish snapshot -gpg-key="$GPG_ID" "$SNAPSHOT"
aptly -config="$CONFIG" publish show "$DISTRIBUTION"
