## Contributing to Briar Desktop

Thank you for looking in this file!

When contributing to the development of Briar Desktop, please first discuss the change you wish to make via issue, email, or any other method with the maintainers before making a change.

If you have any questions regarding the use or development of Briar Desktop,
want to discuss design or simply hang out, please join us in [the Matrix network](https://matrix.to/#/#freenode_#briar:matrix.org)
or [Briar's Mattermost chat](https://chat.briarproject.org/).

Please note we have a [code of conduct](/code-of-conduct.md), please follow it in all your interactions with the project.

## Source repository

Briar Desktop's main source repository is at [code.briarproject.org/briar/briar-desktop](https://code.briarproject.org/briar/briar-desktop).

Development happens in the _main_ branch.

If you need to publish a branch, feel free to do it at any
publically-accessible Git hosting service, although code.briarproject.org
makes things easier for the maintainers.

# Issues, issues and more issues!

There are many ways you can contribute to Briar Desktop, and all of them involve creating issues
in [Briar Desktop's issue tracker](https://code.briarproject.org/briar/briar-desktop/issues). This is the entry point for your contribution.

To create an effective and high quality ticket, try to put the following information on your
ticket:

 1. A detailed description of the issue or feature request
     - For issues, please note your version and add the necessary steps to reproduce the issue.
     - For feature requests, add a detailed description of your proposal.
 2. A checklist of Development tasks
 3. A checklist of Design tasks
 4. A checklist of QA tasks

Don't mind if you have nothing to say about point 2), 3) or 4).

## Issue template
```
[Title of the issue or feature request]

Detailed description of the issue. Put as much information as you can, potentially
with images showing the issue or mockups of the proposed feature.

If it's an issue, add the version and steps to reproduce like this:

Steps to reproduce:

1. Open Briar Desktop
2. Do an Action
3. ...

Briar Desktop version: 0.2.0-beta1

## Design Tasks

* [ ]  design tasks

## Development Tasks

* [ ]  development tasks

## QA Tasks

* [ ]  qa (quality assurance) tasks
```

## Merge Request Process

1. Ensure your code compiles.
2. If you're adding new API, it must be properly documented.
3. The commit message has to be formatted as follows:
   ```
   <summary>

   A paragraph explaining the problem and its context.

   Another one explaining how you solved that.

   Fixes <link to the bug ticket>
   ```
4. You may merge the merge request once you have the sign-off of the maintainers, or if you
   do not have permission to do that, you may request the reviewer to merge it for you.
