/*
 * Briar Desktop
 * Copyright (C) 2021-2022 The Briar Project
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.briarproject.briar.desktop.theme

import androidx.compose.ui.graphics.Color

val Night50 = Color(0xffebf3fa)
val Night500 = Color(0xff435b77)
val Night700 = Color(0xff2e3d4f)
val Night800 = Color(0xff212d3b)
val Night950 = Color(0xff0e171f)

val Gray50 = Color(0xfffafafa)
val Gray100 = Color(0xfff2f2f2)
val Gray200 = Color(0xffdfdfdf)
val Gray300 = Color(0xffcccccc)
val Gray400 = Color(0xffbababa)
val Gray500 = Color(0xffa7a7a7)
val Gray700 = Color(0xff707070)
val Gray800 = Color(0xff4f4f4f)
val Gray900 = Color(0xff2e2e2e)
val Gray950 = Color(0xff1f1f1f)
val materialDarkBg = Color(0xff121212)

val Red300 = Color(0xffea8271)
val Red500 = Color(0xffdb3b21)

val Orange500 = Color(0xfffc9403)
val Orange700 = Color(0xffc26700)

// taken from Android AppCompat DayNight theme as error colors
// https://android.googlesource.com/platform/frameworks/support/+/refs/heads/androidx-appcompat-release/appcompat/appcompat/src/main/res/values/colors_material.xml#102
val DeepOrange400 = Color(0xffff7043)
val DeepOrange500 = Color(0xffff5722)

val Blue400 = Color(0xff418cd8)
val Blue500 = Color(0xff1f78d1) // todo: unused in Android
val Blue600 = Color(0xff1b69b6)
val Blue700 = Color(0xff17599c)
val Blue800 = Color(0xff134a81)

val Lime300 = Color(0xff95de2d)
val Lime500 = Color(0xff74b816)
val Lime700 = Color(0xff53830e)

val TextPrimaryMaterialDark = Color(0xffffffff)
val TextPrimaryMaterialLight = Color(0xde000000)
val TextSecondaryMaterialDark = Color(0xb3ffffff)
val TextSecondaryMaterialLight = Color(0x8a000000)

val briarError = Color(0xffb00020)
