package org.briarproject.api.sync;

public class Group {

	private final GroupId id;
	private final ClientId clientId;
	private final byte[] descriptor;

	public Group(GroupId id, ClientId clientId, byte[] descriptor) {
		this.id = id;
		this.clientId = clientId;
		this.descriptor = descriptor;
	}

	/** Returns the group's unique identifier. */
	public GroupId getId() {
		return id;
	}

	/** Returns the ID of the client to which the group belongs. */
	public ClientId getClientId() {
		return clientId;
	}

	/** Returns the group's descriptor. */
	public byte[] getDescriptor() {
		return descriptor;
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}

	@Override
	public boolean equals(Object o) {
		return o instanceof Group && id.equals(((Group) o).id);
	}
}
