package net.sf.briar.api.messaging;

/** A group to which users may subscribe. */
public class Group {

	private final GroupId id;
	private final String name;
	private final byte[] publicKey;

	public Group(GroupId id, String name, byte[] publicKey) {
		this.id = id;
		this.name = name;
		this.publicKey = publicKey;
	}

	/** Returns the group's unique identifier. */
	public GroupId getId() {
		return id;
	}

	/** Returns the group's name. */
	public String getName() {
		return name;
	}

	/** Returns true if the group is restricted. */
	public boolean isRestricted() {
		return publicKey != null;
	}

	/**
	 * If the group is restricted, returns the public key used to verify the
	 * signatures on all messages sent to the group. If the group is
	 * unrestricted, returns null.
	 */
	public byte[] getPublicKey() {
		return publicKey;
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}

	@Override
	public boolean equals(Object o) {
		return o instanceof Group && id.equals(((Group) o).id);
	}
}
