package net.sf.briar.api.messaging;

import static net.sf.briar.api.transport.TransportConstants.MIN_CONNECTION_LENGTH;

public interface MessagingConstants {

	/**
	 * The maximum length of a serialised packet in bytes. To allow for future
	 * changes in the protocol, this is smaller than the minimum connection
	 * length minus the maximum encryption and authentication overhead.
	 */
	int MAX_PACKET_LENGTH = MIN_CONNECTION_LENGTH / 2;

	/** The maximum number of groups a user may subscribe to. */
	int MAX_SUBSCRIPTIONS = 3000;

	/** The maximum length of a group's name in UTF-8 bytes. */
	int MAX_GROUP_NAME_LENGTH = 50;

	/**
	 * The maximum length of a message body in bytes. To allow for future
	 * changes in the protocol, this is smaller than the maximum packet length
	 * even when all the message's other fields have their maximum lengths.
	 */
	int MAX_BODY_LENGTH = MAX_PACKET_LENGTH - 1024;

	/** The maximum length of a message's content type in UTF-8 bytes. */
	int MAX_CONTENT_TYPE_LENGTH = 50;

	/** The maximum length of a message's subject line in UTF-8 bytes. */
	int MAX_SUBJECT_LENGTH = 100;

	/** The length of a message's random salt in bytes. */
	int SALT_LENGTH = 8;

	/**
	 * The timestamp of the oldest message in the database is rounded using
	 * this modulus to avoid revealing the presence of any particular message.
	 */
	int RETENTION_MODULUS = 60 * 60 * 1000; // 1 hour
}
