package org.briarproject.android.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;

import org.briarproject.android.ActivityComponent;

public abstract class BaseFragment extends Fragment {

	protected BaseFragmentListener listener;

	public abstract String getUniqueTag();

	public abstract void injectFragment(ActivityComponent component);

	@Override
	public void onAttach(Context context) {
		super.onAttach(context);
		try {
			listener = (BaseFragmentListener) context;
		} catch (ClassCastException e) {
			throw new ClassCastException(
					"Using class must implement BaseFragmentListener");
		}
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}


	@Override
	public void onActivityCreated(@Nullable Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
		this.injectFragment(listener.getActivityComponent());
		listener.onFragmentCreated(getUniqueTag());
	}

	public interface BaseFragmentListener {

		void showLoadingScreen(boolean isBlocking, int stringId);

		void hideLoadingScreen();

		void runOnUiThread(Runnable runnable);

		void runOnDbThread(Runnable runnable);

		ActivityComponent getActivityComponent();

		void onFragmentCreated(String tag);
	}
}
